/*
 * Decompiled with CFR 0.152.
 */
package filenet.pe.peorb.test;

import com.filenet.api.core.Connection;
import com.filenet.api.core.Factory;
import com.filenet.api.util.UserContext;
import filenet.pe.peorb.client.ClientInfoUtilities;
import filenet.pe.peorb.test.TestCodeEnum;
import filenet.vw.api.VWException;
import filenet.vw.api.VWExposedFieldDefinition;
import filenet.vw.api.VWPartnerLinkDefinition;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWRosterDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.api.VWTableDefinition;
import filenet.vw.api.VWTransferResult;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.logging.Logger;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import filenet.ws.api.WSDefinition;
import filenet.ws.api.WSOperation;
import filenet.ws.api.WSParam;
import filenet.ws.api.WSPortType;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.security.auth.Subject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APIClientTest
implements Runnable {
    protected static boolean verbose;
    private VWCommandLineArgs c;
    private VWSession ses = new VWSession();
    private String myId;
    private long duration;
    private ArrayList<TestCodeEnum> test = null;
    protected static final String DEFAULT_USER = "qdang";
    protected static final String DEFAULT_PW = "WFQA20zz";
    protected static final String DEFAULT_CEURI = "http://cmdevwin3:9080/wsi/FNCEWS40MTOM/";
    protected static final String DEFAULT_CP = "quynhruby_600";
    protected static final String INTEGER_FIELD = "IntegerField";
    protected static final String INTEGER_FIELD_DESCRIPTION = "A description of field IntegerField";
    protected static final String FLOAT_FIELD = "FloatField";
    protected static final String STRING_FIELD = "StringField";
    protected static final String READ_ONLY_STRING_FIELD = "ReadOnlyStringField";
    protected static final String BOOLEAN_FIELD = "BooleanField";
    protected static final String TIME_FIELD = "TimeField";
    private static final String PEAPITEST_WF_NAME = "PEAPITestWF";
    private static String LF;
    private static final String TEST_WORKFLOW_STRING;
    private static final String TESTWF2_NAME = "QTest1";
    private static final String TESTWF2;

    public static String _get_FILE_DATE() {
        return "$Date:   08 Dec 2008 16:26:10  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.16  $";
    }

    protected static void msg(String id, String s) {
        if (verbose) {
            System.out.println(id + "\t" + Thread.currentThread().getName() + "\t" + s);
        }
    }

    protected APIClientTest(int id, VWCommandLineArgs c) throws Exception {
        String s;
        String ceURI = c.getParameter("ceURI");
        String cp = c.getParameter("cp");
        String username = c.getParameter("username");
        String password = c.getParameter("password");
        int logonOpt = c.getIntParameter("logonOpt", 1);
        if (logonOpt != 3 && (ceURI == null | username == null || password == null)) {
            APIClientTest.printUsage();
        }
        if ((s = c.getParameter("rpcs")) == null) {
            s = c.getParameter("rpc");
        }
        if (s == null) {
            s = "listcp";
        }
        String[] rpcs = s.split(",");
        this.c = c;
        this.myId = "[INSTANCE " + id + "," + Logger.asString(rpcs) + "] ";
        boolean logonRequired = false;
        this.test = new ArrayList(rpcs.length);
        for (String rpc : rpcs) {
            TestCodeEnum t = TestCodeEnum.getTest(rpc);
            logonRequired = logonRequired || t.logonRequired();
            this.test.add(t);
        }
        if (logonRequired) {
            switch (c.getIntParameter("logonOpt", 1)) {
                case 1: {
                    APIClientTest.msg(this.myId, "Logging on normally for " + username + " to " + cp + ", ceURI=" + ceURI);
                    this.ses.setBootstrapCEURI(ceURI);
                    this.ses.logon(username, password, cp);
                    APIClientTest.msg(this.myId, "Successfully logged on..");
                    break;
                }
                case 2: {
                    APIClientTest.msg(this.myId, "Logging on via CE Subject...");
                    Connection conn = Factory.Connection.getConnection((String)ceURI);
                    Subject subject = UserContext.createSubject((Connection)conn, (String)username, (String)password, null);
                    UserContext uc = UserContext.get();
                    uc.pushSubject(subject);
                    this.ses.logon(cp);
                    APIClientTest.msg(this.myId, "Successfully logged on..");
                }
            }
        } else {
            System.out.println("No VWSession.logon is done because the RPCs do not require VWSession.");
        }
        System.out.println(this.myId + " constructed.");
    }

    private void runTests() {
        for (TestCodeEnum t : this.test) {
            this.duration += t.run(this.myId, this.c, this.ses);
        }
    }

    @Override
    public void run() {
        try {
            APIClientTest.msg(this.myId, "Starting...");
            int nIterations = this.c.getIntParameter("nIterations", 1);
            for (int i = 0; i < nIterations; ++i) {
                System.out.printf(this.myId + ":run [%d]\n", i);
                this.runTests();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.ses != null) {
            try {
                this.ses.logoff();
                APIClientTest.msg(this.myId, "Logged off!");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        APIClientTest.msg(this.myId, "Finished...");
    }

    protected long getDuration() {
        return this.duration;
    }

    private static void printUsage() {
        StringBuffer buf = new StringBuffer();
        buf.append("Usage: \njava ").append("-Djava.security.auth.login.config=<CEAPI>/config/jaas.conf.WSI ").append("-cp pe.jar;<CEAPI>/Jace.jar;pe3pt.jar;peResources.jar ").append("filenet.pe.peorb.test.APIClientTest /inputfile api.properties").append("\n\n-------------------------------- api.properties ------------------------------\n").append("#Required properties:\n").append("ceURI=<CEURI>\n").append("cp=ConnectionPoint\n").append("username=xxx\n").append("password=xxx\n").append("\n\n### Optional:\n").append("#logonOpt=1 for normal(default), 2 for using CE Subject pushed on UserContext, 3 for no logon\n").append("#verbose\n").append("#nThreads=# -- number of threads to run the tests\n").append("#nIterations=# -- # of iterations.\n").append("#parallel -- whether to run the tests concurrently..\n").append("#errorFile=<filename> to redirect the System.err\n").append("#rpcs=<rpc--see below>,<rpc..>,<rpc..>  -- to run the tests \n").append("\n\n");
        TestCodeEnum.getTestCodeParams(buf);
        System.err.println(buf.toString());
        System.exit(1);
    }

    public static void main(String[] args) {
        VWCommandLineArgs c = new VWCommandLineArgs(args);
        if (c.isPresent("help") || c.isPresent("?") || c.isPresent("h")) {
            APIClientTest.printUsage();
        }
        Vector<Thread> vThreads = null;
        PrintStream ps = null;
        PrintStream psErr = null;
        try {
            String errorFile;
            if (System.getProperty("ORBDebug") != null) {
                File f = new File("APIClientTestSTDOUT.txt");
                System.out.println("Writing STDOUT output to " + f.getCanonicalPath());
                ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(f)));
                System.setOut(ps);
            }
            if ((errorFile = c.getParameter("errorFile")) != null) {
                File f = new File(errorFile);
                System.out.println("Writing STDERR output to " + f.getCanonicalPath());
                psErr = new PrintStream(new BufferedOutputStream(new FileOutputStream(f), 65535));
                System.setErr(psErr);
            }
            Vector<APIClientTest> vTimers = new Vector<APIClientTest>();
            System.out.println("----------------");
            System.out.println("TEST parameters:");
            System.out.println("----------------");
            c.list(System.out);
            System.out.println("----------------------------------------------------------------------------------------");
            verbose = c.isPresent("verbose");
            int nThreads = c.getIntParameter("nThreads", 1);
            boolean parallel = c.isPresent("parallel");
            if (parallel) {
                vThreads = new Vector<Thread>(nThreads);
            }
            for (int i = 0; i < nThreads; ++i) {
                APIClientTest aPIClientTest = new APIClientTest(i, c);
                vTimers.add(aPIClientTest);
                if (!parallel) {
                    aPIClientTest.run();
                    continue;
                }
                Thread th = new Thread(aPIClientTest);
                vThreads.add(th);
                th.setName("ApiClientTest-" + i);
            }
            if (vThreads != null) {
                for (Thread thread : vThreads) {
                    thread.start();
                    Thread.sleep(500L);
                }
                for (Thread thread : vThreads) {
                    try {
                        thread.join();
                    }
                    catch (Exception e) {}
                }
            }
            APIClientTest.printTimingInfo(vTimers);
            StringBuffer b = new StringBuffer();
            ClientInfoUtilities.AppendRPCTimingInfo(b);
            System.out.println(b);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        System.out.println("\n\n**** C'est fini...");
        if (ps != null) {
            try {
                ps.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (psErr != null) {
            try {
                psErr.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private static void printTimingInfo(Vector<APIClientTest> vTimers) {
        System.out.println("------------- TIMING INFO -----------");
        Enumeration<APIClientTest> timerKeyEnum = vTimers.elements();
        while (timerKeyEnum.hasMoreElements()) {
            APIClientTest t = timerKeyEnum.nextElement();
            System.out.println(t.myId + " took " + t.getDuration() + " ms");
        }
    }

    protected static void createFields(VWTableDefinition t) throws VWException {
        t.createFieldDefinition(INTEGER_FIELD, 1, 0);
        t.createFieldDefinition(FLOAT_FIELD, 8, 0);
        t.createFieldDefinition(BOOLEAN_FIELD, 4, 0);
        t.createFieldDefinition(TIME_FIELD, 256, 0);
        t.createFieldDefinition(STRING_FIELD, 2, 50);
    }

    protected static boolean createQueue(VWSystemConfiguration sc, String qName) throws VWException {
        VWQueueDefinition q = sc.getQueueDefinition(qName);
        if (q == null) {
            q = sc.createQueueDefinition(qName, 1);
            APIClientTest.createFields(q);
            System.out.println("Creating queue: " + qName);
            return true;
        }
        return false;
    }

    protected static boolean createRoster(VWSystemConfiguration sc, String rName) throws VWException {
        VWRosterDefinition r = sc.getRosterDefinition(rName);
        if (r == null) {
            r = sc.createRosterDefinition(rName);
            APIClientTest.createFields(r);
            System.out.println("Creating roster: " + rName);
            return true;
        }
        return false;
    }

    protected static void verifyFields(VWTableDefinition t, String name) throws Exception {
        System.out.println("Verifying " + name);
        VWExposedFieldDefinition[] fields = null;
        fields = t.getFields();
        if (fields == null) {
            throw new Exception("No fields are found for " + name);
        }
        boolean foundInteger = false;
        boolean foundString = false;
        boolean foundBoolean = false;
        boolean foundTime = false;
        boolean foundFloat = false;
        for (VWExposedFieldDefinition f : fields) {
            if (f.getName().equals(INTEGER_FIELD) && f.getFieldType() == 1) {
                foundInteger = true;
                continue;
            }
            if (f.getName().equals(FLOAT_FIELD) && f.getFieldType() == 8) {
                foundFloat = true;
                continue;
            }
            if (f.getName().equals(BOOLEAN_FIELD) && f.getFieldType() == 4) {
                foundBoolean = true;
                continue;
            }
            if (f.getName().equals(TIME_FIELD) && f.getFieldType() == 16) {
                foundTime = true;
                continue;
            }
            if (!f.getName().equals(STRING_FIELD) || f.getFieldType() != 2) continue;
            foundString = true;
        }
        if (!(foundInteger && foundFloat && foundBoolean && foundString && foundTime)) {
            throw new Exception(name + " is incorrectly created!");
        }
    }

    protected static void verifySystemConfig(VWSession ses) {
        try {
            VWSystemConfiguration sysConfig = ses.fetchSystemConfiguration();
            APIClientTest.verifyFields(sysConfig.getQueueDefinition("Q1"), "Q1");
            APIClientTest.verifyFields(sysConfig.getQueueDefinition("Q2"), "Q1");
            APIClientTest.verifyFields(sysConfig.getRosterDefinition("R1"), "R1");
            APIClientTest.verifyFields(sysConfig.getRosterDefinition("R2"), "R2");
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected static void tranferCannedWfl(VWSession ses) {
        APIClientTest.transferingWorkflow(ses, PEAPITEST_WF_NAME, TEST_WORKFLOW_STRING);
        APIClientTest.transferingWorkflow(ses, TESTWF2_NAME, TESTWF2);
    }

    protected static void transferingWorkflow(VWSession ses, String wflName, String wflContents) {
        try {
            String[] curWCs = ses.fetchWorkClassNames(true);
            int nWC = curWCs == null ? 0 : curWCs.length;
            for (int i = 0; i < nWC; ++i) {
                if (!wflName.equals(curWCs[i])) continue;
                return;
            }
            StringBuilder buf = new StringBuilder();
            buf.append("Transferring ").append(wflName).append("...\n");
            VWWorkflowDefinition theWorkflow = VWWorkflowDefinition.read(new ByteArrayInputStream(wflContents.getBytes()));
            VWTransferResult tferErrors = ses.transfer(theWorkflow, "\"QD\"", true, true);
            if (!tferErrors.success()) {
                String[] errStrs = tferErrors.getErrors();
                int nErrors = errStrs == null ? 0 : errStrs.length;
                buf.append(" TransferErrors=\"");
                for (int j = 0; j < nErrors; ++j) {
                    String s = errStrs[j].trim();
                    if (s.length() == 0) continue;
                    buf.append(s).append(" ");
                }
                buf.append("\" ");
            } else {
                buf.append(" VWVersion=\"").append(tferErrors.getVersion());
            }
            System.out.println(buf.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void inspectPL(VWWorkflowDefinition wfDef) {
        try {
            VWPartnerLinkDefinition[] pls = wfDef.getPartnerLinks();
            int nPL = pls == null ? 0 : pls.length;
            for (int i = 0; i < nPL; ++i) {
                VWPartnerLinkDefinition pl = pls[i];
                StringBuilder buf = new StringBuilder("------ PL ").append(pl.getName()).append(" ------\n").append("partnerlinkRef=").append(pl.getPartnerLinkRef()).append("\n").append("partnerEndPoint=").append(pl.getPartnerEndPoint()).append("\n").append(pl.getWSDLRef());
                if (pl.getWSDLRef() != null) {
                    buf.append("[WSDL INFO]");
                    WSDefinition wsdef = WSDefinition.getWSDefinitionFromString(pl.getWSDLRef());
                    WSPortType[] portTypes = wsdef.getPortTypes();
                    if (portTypes != null) {
                        for (WSPortType pt : portTypes) {
                            String portTypeName = pt.getName();
                            WSOperation[] ops = pt.getOperations();
                            if (ops == null) continue;
                            for (WSOperation op : ops) {
                                String operationName = op.getName();
                                buf.append(portTypeName).append(":").append(operationName);
                                WSParam[] params = op.getInMsgParamList();
                                if (params != null) {
                                    buf.append("(");
                                    for (WSParam aParam : params) {
                                        buf.append(aParam.getType()).append(aParam.getName()).append(",");
                                    }
                                    buf.append(")");
                                }
                                buf.append("\n");
                            }
                        }
                    }
                }
                System.out.println(buf.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void getWorkClass(String myId, VWSession ses, int wsId, String wcName) throws Exception {
        if (wcName == null) {
            throw new Exception("WorkClass is null!");
        }
        VWWorkflowDefinition wfDef = ses.fetchWorkflowDefinition(wsId, wcName);
        StringBuffer buf = new StringBuffer();
        wfDef.toXML(buf);
        APIClientTest.msg(myId, "--------- " + wcName + "------------");
        APIClientTest.msg(myId, buf.toString());
    }

    static {
        LF = "\r\n";
        TEST_WORKFLOW_STRING = "<?xml version='1.0' encoding='UTF-8'?>" + LF + "<!DOCTYPE WorkFlowDefinition SYSTEM \"wfdef4.dtd\">" + LF + "<WorkFlowDefinition ApiVersion=\"4.0\"" + LF + "Origin=\"JavaAPI\"" + LF + "\tSubject=\"&quot;" + PEAPITEST_WF_NAME + "&quot;\"" + LF + "\tDescription=\"Go to originator inbox...\"" + LF + "\tName=\"" + PEAPITEST_WF_NAME + "\"" + LF + "\tAuthorTool=\"Process Designer\"" + LF + "\tversionAgnostic=\"false\"" + LF + "\tvalidateUsingSchema=\"true\"" + LF + "\tvalidateFlag=\"true\"" + LF + "\ttransferFlag=\"true\">" + LF + "\t<Field" + LF + "\t\tName=\"peapiString\"" + LF + "\t\tValueExpr=\"&quot;&quot;\"" + LF + "\t\tType=\"string\"" + LF + "\t\tIsArray=\"false\"" + LF + "\t\tMergeType=\"override\"/>" + LF + "\t<Field" + LF + "\t\tName=\"peapiDate\"" + LF + "\t\tValueExpr=\"systemtime()\"" + LF + "\t\tType=\"time\"" + LF + "\t\tIsArray=\"false\"" + LF + "\t\tMergeType=\"override\"/>" + LF + "\t<Field" + LF + "\t\tName=\"peapiInteger\"" + LF + "\t\tValueExpr=\"0\"" + LF + "\t\tType=\"int\"" + LF + "\t\tIsArray=\"false\"" + LF + "\t\tMergeType=\"override\"/>" + LF + "\t<Map" + LF + "\t\tName=\"Workflow\"" + LF + "\t\tMaxStepId=\"5\" >" + LF + "\t\t<Step" + LF + "\t\t\tStepId=\"0\"" + LF + "\t\t\tName=\"LaunchStep\"" + LF + "\t\t\tXCoordinate=\"50\"" + LF + "\t\t\tYCoordinate=\"50\"" + LF + "\t\t\tRequestedInterface=\"Approval Launch HTML (FileNet)\"" + LF + "\t\t\tJoinType=\"none\"" + LF + "\t\t\tSplitType=\"or\"" + LF + "\t\t\tCanReassign=\"true\"" + LF + "\t\t\tCanViewStatus=\"true\"" + LF + "\t\t\tCanViewHistory=\"false\"" + LF + "\t\t\tIgnoreInvalidUsers=\"false\">" + LF + "<Parameter" + LF + "\tName=\"peapiString\"" + LF + "\tValueExpr=\"peapiString\"" + LF + "\tType=\"string\"" + LF + "\tIsArray=\"false\"" + LF + "\tMode=\"inout\"/>" + LF + "<Parameter" + LF + "\tName=\"peapiInteger\"" + LF + "\tValueExpr=\"peapiInteger\"" + LF + "\tType=\"int\"" + LF + "\tIsArray=\"false\"" + LF + "\tMode=\"inout\"/>" + LF + "<Parameter" + LF + "\tName=\"peapiDate\"" + LF + "\tValueExpr=\"peapiDate\"" + LF + "\tType=\"time\"" + LF + "\tIsArray=\"false\"" + LF + "\tMode=\"inout\"/>" + LF + "\t\t\t<Route" + LF + "\t\t\t\tSourceStepId=\"0\"" + LF + "\t\t\t\tDestinationStepId=\"3\"" + LF + "\t\t\t\tRouteId=\"0\"/>" + LF + "\t\t\t<ModelAttributes>" + LF + "\t\t\t\t<ModelAttribute" + LF + "\t\t\t\t\tName=\"UI_StepType\"" + LF + "\t\t\t\t\tType=\"int\"" + LF + "\t\t\t\t\tIsArray=\"false\">" + LF + "\t\t\t\t\t\t<Value Val=\"1\"/>" + LF + "\t\t\t\t</ModelAttribute>" + LF + "\t\t\t</ModelAttributes>" + LF + "\t\t</Step>" + LF + "\t\t<Step" + LF + "\t\t\tStepId=\"3\"" + LF + "\t\t\tName=\"Step1\"" + LF + "\t\t\tXCoordinate=\"196\"" + LF + "\t\t\tYCoordinate=\"50\"" + LF + "\t\t\tRequestedInterface=\"Approval HTML (FileNet)\"" + LF + "\t\t\tQueueName=\"Inbox\"" + LF + "\t\t\tJoinType=\"or\"" + LF + "\t\t\tSplitType=\"or\"" + LF + "\t\t\tCanReassign=\"true\"" + LF + "\t\t\tCanViewStatus=\"true\"" + LF + "\t\t\tCanViewHistory=\"false\"" + LF + "\t\t\tIgnoreInvalidUsers=\"false\">" + LF + "\t\t\t<Participant Val=\"F_Originator\" />" + LF + "<Parameter" + LF + "\tName=\"peapiString\"" + LF + "\tValueExpr=\"peapiString\"" + LF + "\tType=\"string\"" + LF + "\tIsArray=\"false\"" + LF + "\tMode=\"inout\"/>" + LF + "<Parameter" + LF + "\tName=\"peapiInteger\"" + LF + "\tValueExpr=\"peapiInteger\"" + LF + "\tType=\"int\"" + LF + "\tIsArray=\"false\"" + LF + "\tMode=\"inout\"/>" + LF + "<Parameter" + LF + "\tName=\"peapiDate\"" + LF + "\tValueExpr=\"peapiDate\"" + LF + "\tType=\"time\"" + LF + "\tIsArray=\"false\"" + LF + "\tMode=\"inout\"/>" + LF + "\t\t\t<Route" + LF + "\t\t\t\tSourceStepId=\"3\"" + LF + "\t\t\t\tDestinationStepId=\"5\"" + LF + "\t\t\t\tRouteId=\"1\"/>" + LF + "\t\t\t<ModelAttributes>" + LF + "\t\t\t\t<ModelAttribute" + LF + "\t\t\t\t\tName=\"UI_StepType\"" + LF + "\t\t\t\t\tType=\"int\"" + LF + "\t\t\t\t\tIsArray=\"false\">" + LF + "\t\t\t\t\t\t<Value Val=\"2\"/>" + LF + "\t\t\t\t</ModelAttribute>" + LF + "\t\t\t</ModelAttributes>" + LF + "\t\t</Step>" + LF + "\t\t<Step" + LF + "\t\t\tStepId=\"5\"" + LF + "\t\t\tName=\"Step2\"" + LF + "\t\t\tXCoordinate=\"361\"" + LF + "\t\t\tYCoordinate=\"49\"" + LF + "\t\t\tRequestedInterface=\"Approval HTML (FileNet)\"" + LF + "\t\t\tQueueName=\"Inbox\"" + LF + "\t\t\tJoinType=\"or\"" + LF + "\t\t\tSplitType=\"or\"" + LF + "\t\t\tCanReassign=\"true\"" + LF + "\t\t\tCanViewStatus=\"true\"" + LF + "\t\t\tCanViewHistory=\"false\"" + LF + "\t\t\tIgnoreInvalidUsers=\"false\">" + LF + "\t\t\t<Participant Val=\"F_Originator\" />" + LF + "<Parameter" + LF + "\tName=\"peapiString\"" + LF + "\tValueExpr=\"peapiString\"" + LF + "\tType=\"string\"" + LF + "\tIsArray=\"false\"" + LF + "\tMode=\"inout\"/>" + LF + "<Parameter" + LF + "\tName=\"peapiInteger\"" + LF + "\tValueExpr=\"peapiInteger\"" + LF + "\tType=\"int\"" + LF + "\tIsArray=\"false\"" + LF + "\tMode=\"inout\"/>" + LF + "<Parameter" + LF + "\tName=\"peapiDate\"" + LF + "\tValueExpr=\"peapiDate\"" + LF + "\tType=\"time\"" + LF + "\tIsArray=\"false\"" + LF + "\tMode=\"inout\"/>" + LF + "\t\t\t<ModelAttributes>" + LF + "\t\t\t\t<ModelAttribute" + LF + "\t\t\t\t\tName=\"UI_StepType\"" + LF + "\t\t\t\t\tType=\"int\"" + LF + "\t\t\t\t\tIsArray=\"false\">" + LF + "\t\t\t\t\t\t<Value Val=\"2\"/>" + LF + "\t\t\t\t</ModelAttribute>" + LF + "\t\t\t</ModelAttributes>" + LF + "\t\t</Step>" + LF + "\t</Map>" + LF + "</WorkFlowDefinition>";
        TESTWF2 = "<?xml version='1.0' encoding='UTF-8'?>" + LF + "<!DOCTYPE WorkFlowDefinition SYSTEM \"wfdef4.dtd\">" + LF + "<WorkFlowDefinition ApiVersion=\"4.0\"" + LF + "Origin=\"JavaAPI\"" + LF + "\tSubject=\"&quot;QTest1&quot;\"" + LF + "\tName=\"QTest1\"" + LF + "\tAuthorTool=\"Process Designer\"" + LF + "\tversionAgnostic=\"false\"" + LF + "\tvalidateUsingSchema=\"true\"" + LF + "\tvalidateFlag=\"true\"" + LF + "\ttransferFlag=\"true\">" + LF + "\t<Field" + LF + "\t\tName=\"i\"" + LF + "\t\tValueExpr=\"0\"" + LF + "\t\tType=\"int\"" + LF + "\t\tIsArray=\"false\"" + LF + "\t\tMergeType=\"override\"/>" + LF + "\t<Field" + LF + "\t\tName=\"b\"" + LF + "\t\tValueExpr=\"true\"" + LF + "\t\tType=\"boolean\"" + LF + "\t\tIsArray=\"false\"" + LF + "\t\tMergeType=\"override\"/>" + LF + "\t<Field" + LF + "\t\tName=\"s\"" + LF + "\t\tValueExpr=\"&quot;&quot;\"" + LF + "\t\tType=\"string\"" + LF + "\t\tIsArray=\"false\"" + LF + "\t\tMergeType=\"override\"/>" + LF + "\t<Field" + LF + "\t\tName=\"f\"" + LF + "\t\tValueExpr=\"0.0\"" + LF + "\t\tType=\"float\"" + LF + "\t\tIsArray=\"false\"" + LF + "\t\tMergeType=\"override\"/>" + LF + "\t<Map" + LF + "\t\tName=\"Workflow\"" + LF + "\t\tMaxStepId=\"5\" >" + LF + "\t\t<Step" + LF + "\t\t\tStepId=\"0\"" + LF + "\t\t\tName=\"LaunchStep\"" + LF + "\t\t\tXCoordinate=\"50\"" + LF + "\t\t\tYCoordinate=\"50\"" + LF + "\t\t\tRequestedInterface=\"Approval Launch HTML (FileNet)\"" + LF + "\t\t\tJoinType=\"none\"" + LF + "\t\t\tSplitType=\"or\"" + LF + "\t\t\tCanReassign=\"true\"" + LF + "\t\t\tCanViewStatus=\"true\"" + LF + "\t\t\tCanViewHistory=\"false\"" + LF + "\t\t\tIgnoreInvalidUsers=\"false\">" + LF + "<Parameter" + LF + "\tName=\"s\"" + LF + "\tValueExpr=\"s\"" + LF + "\tType=\"string\"" + LF + "\tIsArray=\"false\"" + LF + "\tMode=\"inout\"/>" + LF + "<Parameter" + LF + "\tName=\"i\"" + LF + "\tValueExpr=\"i\"" + LF + "\tType=\"int\"" + LF + "\tIsArray=\"false\"" + LF + "\tMode=\"inout\"/>" + LF + "<Parameter" + LF + "\tName=\"f\"" + LF + "\tValueExpr=\"f\"" + LF + "\tType=\"float\"" + LF + "\tIsArray=\"false\"" + LF + "\tMode=\"inout\"/>" + LF + "<Parameter" + LF + "\tName=\"b\"" + LF + "\tValueExpr=\"b\"" + LF + "\tType=\"boolean\"" + LF + "\tIsArray=\"false\"" + LF + "\tMode=\"inout\"/>" + LF + "\t\t\t<Route" + LF + "\t\t\t\tSourceStepId=\"0\"" + LF + "\t\t\t\tDestinationStepId=\"3\"" + LF + "\t\t\t\tRouteId=\"0\">" + LF + "\t\t\t\t<ModelAttributes>" + LF + "\t\t\t\t\t<ModelAttribute" + LF + "\t\t\t\t\t\tName=\"UI_RouteWeight\"" + LF + "\t\t\t\t\t\tType=\"int\"" + LF + "\t\t\t\t\t\tIsArray=\"false\">" + LF + "\t\t\t\t\t\t\t<Value Val=\"100\"/>" + LF + "\t\t\t\t\t</ModelAttribute>" + LF + "\t\t\t\t</ModelAttributes>" + LF + "\t\t\t</Route>" + LF + "\t\t\t<ModelAttributes>" + LF + "\t\t\t\t<ModelAttribute" + LF + "\t\t\t\t\tName=\"UI_StepType\"" + LF + "\t\t\t\t\tType=\"int\"" + LF + "\t\t\t\t\tIsArray=\"false\">" + LF + "\t\t\t\t\t\t<Value Val=\"1\"/>" + LF + "\t\t\t\t</ModelAttribute>" + LF + "\t\t\t</ModelAttributes>" + LF + "\t\t</Step>" + LF + "\t\t<Step" + LF + "\t\t\tStepId=\"3\"" + LF + "\t\t\tName=\"Q1\"" + LF + "\t\t\tXCoordinate=\"240\"" + LF + "\t\t\tYCoordinate=\"71\"" + LF + "\t\t\tRequestedInterface=\"Approval HTML (FileNet)\"" + LF + "\t\t\tQueueName=\"Q1\"" + LF + "\t\t\tJoinType=\"or\"" + LF + "\t\t\tSplitType=\"or\"" + LF + "\t\t\tCanReassign=\"true\"" + LF + "\t\t\tCanViewStatus=\"true\"" + LF + "\t\t\tCanViewHistory=\"false\"" + LF + "\t\t\tIgnoreInvalidUsers=\"false\">" + LF + "<Parameter" + LF + "\tName=\"s\"" + LF + "\tValueExpr=\"s\"" + LF + "\tType=\"string\"" + LF + "\tIsArray=\"false\"" + LF + "\tMode=\"inout\"/>" + LF + "<Parameter" + LF + "\tName=\"i\"" + LF + "\tValueExpr=\"i\"" + LF + "\tType=\"int\"" + LF + "\tIsArray=\"false\"" + LF + "\tMode=\"inout\"/>" + LF + "<Parameter" + LF + "\tName=\"f\"" + LF + "\tValueExpr=\"f\"" + LF + "\tType=\"float\"" + LF + "\tIsArray=\"false\"" + LF + "\tMode=\"inout\"/>" + LF + "<Parameter" + LF + "\tName=\"b\"" + LF + "\tValueExpr=\"b\"" + LF + "\tType=\"boolean\"" + LF + "\tIsArray=\"false\"" + LF + "\tMode=\"inout\"/>" + LF + "\t\t\t<Route" + LF + "\t\t\t\tSourceStepId=\"3\"" + LF + "\t\t\t\tDestinationStepId=\"5\"" + LF + "\t\t\t\tRouteId=\"1\">" + LF + "\t\t\t\t<ModelAttributes>" + LF + "\t\t\t\t\t<ModelAttribute" + LF + "\t\t\t\t\t\tName=\"UI_RouteWeight\"" + LF + "\t\t\t\t\t\tType=\"int\"" + LF + "\t\t\t\t\t\tIsArray=\"false\">" + LF + "\t\t\t\t\t\t\t<Value Val=\"100\"/>" + LF + "\t\t\t\t\t</ModelAttribute>" + LF + "\t\t\t\t</ModelAttributes>" + LF + "\t\t\t</Route>" + LF + "\t\t\t<ModelAttributes>" + LF + "\t\t\t\t<ModelAttribute" + LF + "\t\t\t\t\tName=\"UI_StepType\"" + LF + "\t\t\t\t\tType=\"int\"" + LF + "\t\t\t\t\tIsArray=\"false\">" + LF + "\t\t\t\t\t\t<Value Val=\"2\"/>" + LF + "\t\t\t\t</ModelAttribute>" + LF + "\t\t\t</ModelAttributes>" + LF + "\t\t</Step>" + LF + "\t\t<Step" + LF + "\t\t\tStepId=\"5\"" + LF + "\t\t\tName=\"Q2\"" + LF + "\t\t\tXCoordinate=\"365\"" + LF + "\t\t\tYCoordinate=\"84\"" + LF + "\t\t\tRequestedInterface=\"Approval HTML (FileNet)\"" + LF + "\t\t\tQueueName=\"Q2\"" + LF + "\t\t\tJoinType=\"or\"" + LF + "\t\t\tSplitType=\"or\"" + LF + "\t\t\tCanReassign=\"true\"" + LF + "\t\t\tCanViewStatus=\"true\"" + LF + "\t\t\tCanViewHistory=\"false\"" + LF + "\t\t\tIgnoreInvalidUsers=\"false\">" + LF + "<Parameter" + LF + "\tName=\"s\"" + LF + "\tValueExpr=\"s\"" + LF + "\tType=\"string\"" + LF + "\tIsArray=\"false\"" + LF + "\tMode=\"inout\"/>" + LF + "<Parameter" + LF + "\tName=\"i\"" + LF + "\tValueExpr=\"i\"" + LF + "\tType=\"int\"" + LF + "\tIsArray=\"false\"" + LF + "\tMode=\"inout\"/>" + LF + "<Parameter" + LF + "\tName=\"f\"" + LF + "\tValueExpr=\"f\"" + LF + "\tType=\"float\"" + LF + "\tIsArray=\"false\"" + LF + "\tMode=\"inout\"/>" + LF + "<Parameter" + LF + "\tName=\"b\"" + LF + "\tValueExpr=\"b\"" + LF + "\tType=\"boolean\"" + LF + "\tIsArray=\"false\"" + LF + "\tMode=\"inout\"/>" + LF + "\t\t\t<ModelAttributes>" + LF + "\t\t\t\t<ModelAttribute" + LF + "\t\t\t\t\tName=\"UI_StepType\"" + LF + "\t\t\t\t\tType=\"int\"" + LF + "\t\t\t\t\tIsArray=\"false\">" + LF + "\t\t\t\t\t\t<Value Val=\"2\"/>" + LF + "\t\t\t\t</ModelAttribute>" + LF + "\t\t\t</ModelAttributes>" + LF + "\t\t</Step>" + LF + "\t</Map>" + LF + "</WorkFlowDefinition>";
    }
}

